//AIM:Design of FIR filter.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will consider a case of normalised Linear Phase FIR filter, with Length 7 and cut off frequency: 1 rad/sec. 
M = 7;// Filter Length
omegac = 1;// Digital Cuttoff Freq Wc = 1 rad/sample (Considering Normalised)
L = (M-1)/2;
for  n = 1:M
        hdn = omegac/%pi;
        disp(hdn)
    end
for n = 1:M;
    wn = 1;
end
h=hdn*wn;
[mag,fr]=frmag(h,512);
db_magnitude= 20*log10(mag);
plot2d(fr,db_magnitude)
xlabel('Frequency');
ylabel('Magnitude in dB');
title('Frequency response of FIR filter using Rectangular window')
//Expected output:0.3183099,0.3183099,0.3183099,0.3183099,0.3183099,0.3183099,0.3183099 
